<html>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/libs/fontawesome/css/fontawesome.css" rel="stylesheet">
    <link href="assets/libs/fontawesome/css/brands.css" rel="stylesheet">
    <link href="assets/libs/fontawesome/css/solid.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/libs/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <title>Teams</title>
    <style>
        .teams-heading {
            height: 430px;
        }

        html,
        body {
            max-width: 100vw;
            overflow-x: hidden;
        }

        .teams-feature {
            margin-top: -230px;
        }

        .teams-feature>div {
            height: 340px;
            clip-path: polygon(20% 0%, 100% 0%, 80% 100%, 0% 100%);
        }

        .text-bg {
            color: transparent;
            -webkit-text-stroke-color: #FFF;
            -webkit-text-stroke-width: 2px;
            text-transform: uppercase;
            font-weight: 500;
            font-style: italic;
            font-size: 50vh;
            margin-top: -130px;
            margin-left: -40px;
            opacity: 0.4;
            pointer-events: none;
        }

        .team-card {
            display: block;
            height: 280px;
            clip-path: polygon(25% 0%, 100% 0%, 75% 100%, 0% 100%);
            transition: transform 0.3s ease;
        }

        .team-card-bg {
            background-size: cover;
            background-position: center;
            transition: inherit;
            height: 100%;
            width: 100%;
        }

        .team-name {
            color: #fff;
            text-align: right;
            font-size: 30px;
            font-weight: bolder;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
            right: 0;
            margin-right: 1.5rem;
        }

        .team-card:hover {
            transform: translateY(-5px);
            cursor: pointer;
            z-index: 1;
        }

        .team-card:hover .team-card-bg {
            transform: scale(1.03);
        }

        .team-name {
            transition: all 0.3s ease;
        }

        @media (max-width: 1200px) {
            .teams-feature {
                margin-top: -200px;
            }

            .team-card {
                height: 240px;
                clip-path: polygon(23% 0%, 100% 0%, 77% 100%, 0% 100%);
            }

            .text-bg {
                font-size: 45vh;
                margin-top: -120px;
            }

            .team-name {
                font-size: 26px;
            }
        }

        @media (max-width: 992px) {
            .teams-feature {
                margin-top: -220px;
            }

            .team-card {
                flex: 0 0 calc(37% - 0.5rem) !important;
                max-width: calc(50% - 0.5rem) !important;
                height: 200px !important;
                margin-left: 75px;
                margin-bottom: 40px;
            }

            .teams-feature>.col-lg-1 {
                display: none !important;
            }

            .text-bg {
                font-size: 42vh;
                margin-top: -120px;
                margin-left: -30px;
            }

            .team-name {
                font-size: 22px;
                margin-right: 1rem;
            }

            .teams-heading {
                height: 340px;
            }

            .mt-5 {
                margin-top: 0rem !important;
            }

            .teams-feature>div {
                height: 0px;
                clip-path: polygon(20% 0%, 100% 0%, 80% 100%, 0% 100%);
            }

            .col-lg-1 {
                display: none;
            }
        }

        @media (max-width: 768px) {
            .teams-feature {
                margin-top: -150px;
            }

            .team-card {
                height: 180px;
                clip-path: polygon(19% 0%, 100% 0%, 81% 100%, 0% 100%);
            }

            .text-bg {
                font-size: 32vh;
                margin-top: -80px;
                margin-left: -30px;
            }

            .team-name {
                font-size: 20px;
                margin-right: 0.8rem;
            }

            .col-1 {
                flex: 0 0 auto;
                width: 11.333333%;
            }

            .footer-copy {
                font-size: 1.7vh;
            }

            .container-fluid {
                padding-left: 15px;
                padding-right: 15px;
            }

            .main-header .banner-slider,
            .main-header .last-news,
            .main-header .banner-ad {
                padding-left: 15px !important;
                padding-right: 15px !important;
            }
        }

        @media (max-width: 576px) {
            .teams-feature {
                margin-top: -120px;
            }

            .team-card {
                height: 160px;
                clip-path: polygon(17% 0%, 100% 0%, 83% 100%, 0% 100%);
            }

            .text-bg {
                font-size: 24vh;
                margin-top: -55px;
                margin-left: -15px;
            }

            .team-name {
                font-size: 18px;
                margin-right: 0.5rem;
            }

            .team-card {
                flex: 0 0 calc(37% - 0.5rem) !important;
                max-width: calc(50% - 0.5rem) !important;
                height: 200px !important;
                margin-left: 55px;
                margin-bottom: 40px;
            }

            .page-heading {
                color: #FFF;
                font-size: 50px;
                font-style: italic;
                text-transform: uppercase;
                margin-top: -5px;
                margin-bottom: 35px;
            }

            .col-5 {
                flex: 0 0 auto;
                width: 100%;
            }

            .sponsors {
                background-color: #db0000;
                width: 100%;
                height: 300px;
                line-height: 90px;
            }

            .sponsors-separator {
                width: 10px;
                height: 10px;
                background-color: #FFF;
                border-radius: 5px;
                display: none;
                line-height: 90px;
            }

            .col-5.c1 {
                flex: 0 0 auto;
                width: 65.666667%;
                margin-left: 100px;
            }

            .container-fluid {
                padding-left: 15px;
                padding-right: 15px;
            }

            .text-about-us {
                font-size: 1rem;
                padding: 0 15px;
                word-wrap: break-word;
                overflow-wrap: break-word;
            }

            .col-md-8.offset-md-2.col-sm-12 {
                width: 100%;
                margin-left: 0;
                padding: 0 15px;
            }

            .players-col {
                margin-left: 0 !important;
                margin-right: 0 !important;
            }

            .players-col > .col {
                padding-left: 10px;
                padding-right: 10px;
            }
        }

        @media (max-width: 435px) {
            .teams-feature {
                margin-top: -100px;
            }

            .team-card {
                height: 140px;
                clip-path: polygon(15% 0%, 100% 0%, 85% 100%, 0% 100%);
            }

            .text-bg {
                font-size: 17vh;
                margin-top: -85px;
            }

            .team-name {
                font-size: 16px;
            }

            .team-card {
                flex: 0 0 calc(37% - 0.5rem) !important;
                max-width: calc(50% - 0.5rem) !important;
                height: 200px !important;
                margin-left: 45px;
                margin-bottom: 40px;
            }

            .teams-heading {
                height: 300px;
            }

            .col-4 {
                flex: 0 0 auto;
                width: 41.333333%;
            }

            .sponsors {
                background-color: #db0000;
                width: 100%;
                height: 230px;
                line-height: 70px;
            }

            .sponsor-single {
                filter: invert(100%);
                height: 32px;
            }

            .col-4.f1 {
                flex: 0 0 auto;
                width: 33.33333333%;
                margin-right: 10px;
            }

            .col-5.c1 {
                margin-left: 77px;
            }

            .footer-copy {
                font-size: 2vh;
            }

            .col-4.f1 {
                flex: 0 0 auto;
                width: 33.33333333%;
                margin-right: 30px;
                margin-left: -20px;
            }
        }
    </style>
</head>

<body>
    <?php include_once("partials/navbar.php") ?>

    <div class="container-fluid">
        <div class="row teams-heading pt-3">
            <div class="col text-center">
                <h2 class="page-heading">As nossas equipas</h2>
                <h2 class="text-bg">EQUIPAS</h2>
            </div>
        </div>

        <div class="row teams-feature">
            <div class="col-lg-1"></div>
            <?php
            $teams = [
                [
                    "title" => "CS2",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "LOL",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "EA FC",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "F1",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "FIGHTING",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],

                [
                    "title" => "CS2",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "LOL",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "EA FC",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "F1",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
                [
                    "title" => "FIGHTING",
                    "image" => "https://i.imgur.com/2Yn4c2N.jpg",
                    'link'  => 'https://ftw.pt'
                ],
            ];

            foreach ($teams as $k => $v):
                if ($k !== 0 && $k % 5 === 0): ?>
                    <div class="col-lg-1"></div>
                    <div class="col-lg-1"></div>
                <?php endif; ?>

                <?php $class = $k >= 5 ? 'mt-5' : ''; ?>
                <a href="<?= $v['link'] ?>" class="col-lg-2 <?= $class ?> text-decoration-none p-0 position-relative team-card">
                    <div class="team-card-bg h-100 w-100"
                        style="background-image: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 80%, rgba(0,0,0,0) 100%), url('<?= $v['image'] ?>')">
                        <div class="team-name position-absolute end-0 me-4">
                            <?= $v['title'] ?>
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>
        </div>
    </div>

    <?php include_once("partials/footer.php"); ?>
</body>

</html>