<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link href="assets/libs/fontawesome/css/fontawesome.css" rel="stylesheet">
    <link href="assets/libs/fontawesome/css/brands.css" rel="stylesheet">
    <link href="assets/libs/fontawesome/css/solid.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/libs/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/team-single.css">
</head>

<body>
    <?php include_once("partials/navbar.php") ?>

    <div class=" px-0">
        <div class="row team-feature-heading pt-3 mx-0">
            <div class="col text-center team-name">
                <h2>CS2 Team</h2>
            </div>
            <h2 class="text-bg-top">JOGADORES</h2>
        </div>

        <div class="row team-feature mx-0">
            <div class="col-9">
                <?php
                $players = [
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2023/q1/ag1l-min.png",
                        "nick" => "Ag1l",
                        "name" => "André Gil",
                    ],
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2023/q1/stadodo-min.png",
                        "nick" => "Stadodo",
                        "name" => "Renato Gonçalves",
                    ],
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2023/q1/nopeej-minv2.png",
                        "nick" => "Nopeej",
                        "name" => "Filipe Dias",
                    ],
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2023/q2/pr-min.png",
                        "nick" => "PR",
                        "name" => "Paulo Silva",
                    ],
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2023/q2/shr-min.png",
                        "nick" => "Shr",
                        "name" => "José Gil",
                    ],
                ];

                $tech = [
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2022/outubro/optimized/vts-min.png",
                        "nick" => "vts",
                        "name" => "Rui Soares",
                    ],
                    [
                        "image" => "https://cdn.ftw.pt/website/files/images/players/CSGO/2022/outubro/optimized/vts-min.png",
                        "nick" => "sp3kan",
                        "name" => "Telmo Flores",
                    ],
                ];
                ?>

                <div class="row players-col">
                    <?php foreach ($players as $pl) { ?>
                        <div class="col">
                            <div class="player-container">
                                <div class="player-img"
                                    style="background-image: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 20%, rgba(0,0,0,0) 100%),url('<?= $pl["image"] ?>')">
                                </div>
                                <div class="single-player"></div>
                                <div class="player-nick"><?= $pl["nick"] ?></div>
                            </div>
                            <div class="player-info">
                                <div class="player-name"><?= $pl['name'] ?></div>
                                <div class="player-socials">
                                    <a href="#"><i class="fa-brands fa-instagram"></i></a>
                                    <a href="#"><i class="fa-brands fa-x-twitter"></i></a>
                                    <a href="#"><i class="fa-brands fa-twitch"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

            <div class="col-3">
                <div class="row tech-col">
                    <?php foreach ($tech as $pl) { ?>
                        <div class="col tech">
                            <div class="player-container tech">
                                <div class="player-img tech"
                                    style="background-image: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 20%, rgba(0,0,0,0) 100%),url('<?= $pl["image"] ?>')">
                                </div>
                                <div class="single-player tech"></div>
                                <div class="player-nick tech"><?= $pl["nick"] ?></div>
                            </div>
                            <div class="player-info tech">
                                <div class="player-name tech"><?= $pl['name'] ?></div>
                                <div class="player-socials tech">
                                    <a href="#"><i class="fa-brands fa-instagram"></i></a>
                                    <a href="#"><i class="fa-brands fa-x-twitter"></i></a>
                                    <a href="#"><i class="fa-brands fa-twitch"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="row awards-row mt-5 mb-5 mx-0">
            <div class="col-2 trophy-bg px-0"></div>
            <div class="col-7 awards-container pt-4 pb-4 px-0">
                <h3>Últimos Awards</h3>
                <div class="awards-table text-white">
                    <?php for ($i = 0; $i < 5; $i++) { ?>
                        <div class="tr">
                            <div class="award-img">
                                <?php if ($i < 3) { ?>
                                    <img src="assets/imgs/stat/awards/<?= ($i + 1) ?>.png">
                                <?php } else {
                                    echo ($i + 1) . "º";
                                } ?>
                            </div>
                            <div class="award-name">Master League Portugal S11</div>
                            <div class="award-date">17-06-2023</div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="col-3 crowd-bg px-0"></div>
        </div>

        <div class="row teams-heading pt-3 mx-0">
            <div class="col text-center">
                <h2 class="page-heading">Mais Modalidades</h2>
                <h2 class="text-bg">Modalidades</h2>
            </div>
        </div>

        <div class="row teams-feature mx-0">
            <div class="col-lg-1"></div>
            <?php
            $teams = [
                ["title" => "CS2", "image" => "https://i.imgur.com/2Yn4c2N.jpg", "link" => "https://ftw.pt"],
                ["title" => "LOL", "image" => "https://i.imgur.com/2Yn4c2N.jpg", "link" => "https://ftw.pt"],
                ["title" => "EA FC", "image" => "https://i.imgur.com/2Yn4c2N.jpg", "link" => "https://ftw.pt"],
                ["title" => "F1", "image" => "https://i.imgur.com/2Yn4c2N.jpg", "link" => "https://ftw.pt"],
                ["title" => "FIGHTING", "image" => "https://i.imgur.com/2Yn4c2N.jpg", "link" => "https://ftw.pt"],
            ];
            foreach ($teams as $k => $v) { ?>
                <?php if ($k !== 0 && $k % 5 === 0) { ?>
                    <div class="col-lg-1"></div>
                    <div class="col-lg-1"></div>
                <?php } ?>

                <?php $class = "";
                if ($k >= 5)
                    $class = "mt-5"; ?>
                <a href="<?= $v['link'] ?>"
                    class="col-lg-2 <?= $class ?> text-decoration-none p-0 position-relative team-card">
                    <div class="h-100 w-100 team-card-bg"
                        style="background-image: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 80%, rgba(0,0,0,0) 100%), url('<?= $v['image'] ?>');">
                        >
                        <div class="team-name position-absolute end-0 me-4">
                            <?= $v['title'] ?>
                        </div>
                    </div>
                </a>
            <?php } ?>
        </div>
    </div>
    </div>

    <?php include_once("partials/footer.php"); ?>

    <style>
        .team-card {
            display: block;
            height: 280px;
            clip-path: polygon(25% 0%, 100% 0%, 75% 100%, 0% 100%);
            transition: transform 0.3s ease;
        }

        .text-bg {
            color: transparent;
            -webkit-text-stroke-color: #FFF;
            -webkit-text-stroke-width: 2px;
            text-transform: uppercase;
            font-weight: 500;
            font-style: italic;
            font-size: 39vh;
            margin-top: -135px;
            margin-left: -40px;
            opacity: 0.4;
            pointer-events: none;
        }

        .team-card-bg {
            background-size: cover;
            background-position: center;
            transition: inherit;
            height: 100%;
            width: 100%;
            background-image: linear-gradient(0deg, rgba(0, 0, 0, 0.8) 0%, rgba(0, 0, 0, 0) 80%, rgba(0, 0, 0, 0) 100%);
        }

        .team-name {
            color: #fff;
            text-align: right;
            font-size: 30px;
            font-weight: bolder;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
            right: 0;
            margin-right: 1.5rem;
        }

        .teams-feature .team-name {
            align-self: flex-end;
            width: 75%;
            font-size: 50px;
            font-weight: 500;
            font-style: italic;
            bottom: 13rem;
        }

        .team-card:hover {
            transform: translateY(-5px);
            cursor: pointer;
            z-index: 1;
        }

        .team-card:hover .team-card-bg {
            transform: scale(1.03);
        }

        .team-name {
            transition: all 0.3s ease;
        }

        .text-bg-top {
            color: transparent;
            -webkit-text-stroke-color: #FFF;
            -webkit-text-stroke-width: 2px;
            text-transform: uppercase;
            font-weight: 500;
            font-style: italic;
            font-size: 52vh;
            margin-top: -135px;
            opacity: 0.4;
            pointer-events: none;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 100vw;
            text-align: center;
            overflow: hidden;
        }

        .text-bg {
            color: transparent;
            -webkit-text-stroke-color: #FFF;
            -webkit-text-stroke-width: 2px;
            text-transform: uppercase;
            font-weight: 500;
            font-style: italic;
            font-size: 46vh;
            margin-top: -155px;
            margin-left: -40px;
            opacity: 0.4;
            pointer-events: none;
        }
        /* Media Queries */

        @media (max-width: 1200px) {

            .text-bg-top {
                color: transparent;
                -webkit-text-stroke-color: #FFF;
                -webkit-text-stroke-width: 2px;
                text-transform: uppercase;
                font-weight: 500;
                font-style: italic;
                font-size: 35vh;
                margin-top: -20px;
                opacity: 0.4;
                pointer-events: none;
                position: absolute;
                left: 49%;
                transform: translateX(-50%);
                width: 100%;
                max-width: 100vw;
                text-align: center;
                overflow: hidden;
            }

            .text-bg {
                font-size: 31vh;
                margin-top: -85px;
            }

            .awards-table div.tr {
                height: 60px;
                line-height: 60px;
                text-transform: uppercase;
                font-size: 1.8rem;
                width: 100%;
            }

            #topnav {
                text-transform: uppercase;
                font-size: 18px;
            }

            .team-card {
                height: 240px;
                clip-path: polygon(23% 0%, 100% 0%, 77% 100%, 0% 100%);
            }

            .team-name {
                font-size: 26px;
            }

            .teams-feature {
                margin-top: -270px;
            }

            .teams-feature .team-name {
                align-self: flex-end;
                text-align: right;
                width: 75%;
                font-size: 35px;
                font-weight: 500;
                font-style: italic;
                bottom: 12rem;
            }
        }

        @media (max-width: 992px) {
            .awards-container {
                background-color: #171716;
                clip-path: polygon(10% 0, 100% 0, 90% 100%, 0% 100%);
                width: 70%;
            }

            .crowd-bg {
                background-image: url(/assets/imgs/stat/ftw-army-min.jpg);
                background-position: center center;
                background-size: cover;
                filter: grayscale(100%);
                clip-path: polygon(35% 0, 100% 0, 100% 100%, 0% 100%);
                width: 17%;
            }

            .player-name {
                color: #000;
                font-style: italic;
                font-size: 1.3rem;
            }

            .trophy-bg {
                background-image: url(/assets/imgs/stat/trophy.png);
                background-position: center center;
                background-size: contain;
                background-repeat: no-repeat;
                clip-path: polygon(0 0, 100% 0, 80% 100%, 0% 100%);
                width: 13%;
            }

            .text-bg-top {
                font-size: 29vh;
            }

            .team-card {
                height: 240px;
                width: 195px;
                margin-left: 3px;
                clip-path: polygon(23% 0%, 100% 0%, 77% 100%, 0% 100%);
            }

            .teams-feature>div {
                height: 5px;
            }

            .text-bg {
                font-size: 26vh;
                margin-top: -70px;
            }

            .team-feature {
                margin-top: -220px;
                margin-right: 30px !important;
            }

            .tech-col .player-name {
                font-size: 1.2rem;
            }

            .player-name {
                color: #000;
                font-style: italic;
                font-size: 1.2rem;
            }
        }

        @media (max-width: 768px) {

            .trophy-bg,
            .crowd-bg {
                display: none;
            }

            .awards-container {
                background-color: #171716;
                clip-path: polygon(10% 0, 100% 0, 90% 100%, 0% 100%);
                width: 90%;
                margin-left: 35px;
                margin-top: -23px;
            }

            .player-nick {
                color: #FFF;
                font-style: italic;
                text-align: right;
                text-transform: uppercase;
                margin-right: 22%;
                font-size: 1.5rem;
                margin-top: -50px;
                position: absolute;
                width: 78%;
                z-index: 999;
            }

            .tech-col .player-nick {
                font-size: 1.5rem;
                margin-top: -45px;
            }

            .team-card {
                height: 240px;
                width: 150px;
                margin-left: 3px;
                clip-path: polygon(23% 0%, 100% 0%, 77% 100%, 0% 100%);
            }

            .teams-feature .team-name {
                align-self: flex-end;
                text-align: right;
                width: 55%;
                font-size: 30px;
                font-weight: 500;
                font-style: italic;
                bottom: 12rem;
            }

            .text-bg {
                font-size: 20vh;
                margin-top: -50px;
            }

            .player-img {
                position: absolute;
                height: 350px;
                background-size: cover;
                background-position: bottom center;
                width: 100%;
                margin-top: calc(270px - 350px);
                z-index: 999;
                clip-path: polygon(0 0, 100% 0%, 100% 80px, 100% 80px, 80% 100%, 0 100%, 5% 80px, 0% 80px);
            }

            .single-player {
                background-color: #ececec;
                height: 270px;
                width: 100%;
                margin: 0 auto;
                clip-path: polygon(6% 0%, 100% 0%, 80% 100%, 0% 100%);
            }

            .tech-col .player-img {
                height: 270px;
                margin-top: calc(200px - 270px);
                clip-path: polygon(0 0, 100% 0%, 100% 70px, 100% 70px, 80% 100%, 0 100%, 6% 70px, 0% 70px);
            }
        }

        @media (max-width: 576px) {
            .awards-table div.tr {
                height: 60px;
                line-height: 60px;
                text-transform: uppercase;
                font-size: 1.3rem;
                width: 100%;
            }

            .awards-table img {
                max-height: 30px;
                margin-top: 15px;
            }

            .sponsors {
                background-color: #db0000;
                width: 100%;
                height: 300px;
                line-height: 90px;
            }

            .sponsors-separator {
                width: 10px;
                height: 10px;
                background-color: #FFF;
                border-radius: 5px;
                display: none;
                line-height: 90px;
            }

            .col-5 {
                flex: 0 0 auto;
                width: 100%;
            }

            .col-5.c1 {
                flex: 0 0 auto;
                width: 65.666667%;
                margin-left: 100px;
            }

            .container-fluid {
                padding-left: 15px;
                padding-right: 15px;
            }

            .text-about-us {
                font-size: 1rem;
                padding: 0 15px;
                word-wrap: break-word;
                overflow-wrap: break-word;
            }

            .col-md-8.offset-md-2.col-sm-12 {
                width: 100%;
                margin-left: 0;
                padding: 0 15px;
            }

            .players-col {
                margin-left: 0 !important;
                margin-right: 0 !important;
            }

            .players-col > .col {
                padding-left: 10px;
                padding-right: 10px;
            }
        }

        @media (max-width: 768px) {
            html {
                overflow-x: hidden !important;
                max-width: 100vw;
            }

            body {
                overflow-x: hidden !important;
                max-width: 100vw;
                width: 100%;
            }

            * {
                max-width: 100%;
                box-sizing: border-box;
            }

            .team-feature-heading {
                height: 380px;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: center;
                padding-top: 30px !important;
            }

            .text-bg {
                font-size: 15vh;
                margin-top: -45px;
                margin-left: 0 !important;
                left: 50%;
                transform: translateX(-50%);
                width: 100%;
            }

            .text-bg-top {
                font-size: 16vh;
                margin-top: 0;
                margin-left: 0 !important;
                left: 50%;
                transform: translateX(-50%);
                position: relative;
                width: 100%;
                text-align: center;
            }

            .team-name {
                text-align: center;
                width: 100%;
                display: flex;
                justify-content: center;
                align-items: center;
                position: relative;
                z-index: 10;
                margin-bottom: 0;
            }

            .team-name>h2 {
                color: #FFF;
                font-size: 50px;
                font-style: italic;
                text-transform: uppercase;
                margin-top: 0;
                margin-bottom: 0;
                text-align: center;
            }

            .team-card {
                height: 180px;
                width: 30%;
                margin: 5px;
                clip-path: polygon(23% 0%, 100% 0%, 77% 100%, 0% 100%);
            }

            .teams-feature {
                margin-top: -270px;
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                padding: 0 10px;
            }

            .teams-feature .col-lg-1 {
                display: none;
            }

            .teams-feature .team-name {
                font-size: 28px;
                bottom: 20px;
                width: 80%;
            }

            .awards-container {
                background-color: #171716;
                clip-path: polygon(10% 0, 100% 0, 90% 100%, 0% 100%);
                width: 93%;
                margin-left: 20px;
                margin-top: -10px;
            }

            .awards-container {
                background-color: #171716;
                clip-path: polygon(10% 0, 100% 0, 90% 100%, 0% 100%);
                width: 93%;
                max-width: 93%;
                margin-left: 20px;
                margin-top: -10px;
            }

            .team-feature {
                margin-top: -220px;
                margin-right: 0 !important;
                margin-left: 0 !important;
                display: flex;
                flex-wrap: wrap;
                max-width: 100vw;
            }

            .row {
                margin-left: 0;
                margin-right: 0;
                max-width: 100%;
            }

            .players-col {
                max-width: 100%;
            }

            .col-9 {
                flex: 0 0 100%;
                width: 100%;
                max-width: 100%;
                padding: 0 15px;
                order: 1;
            }

            .col-3 {
                flex: 0 0 100%;
                width: 100%;
                max-width: 100%;
                padding: 0 15px;
                order: 2;
            }

            .player-container {
                position: relative;
                width: 100%;
                max-width: 100%;
                margin-bottom: 10px;
            }

            .single-player {
                background-color: #ececec;
                height: 270px;
                width: 100%;
                margin: 75px auto 0;
                clip-path: polygon(10% 0%, 100% 0%, 90% 100%, 0% 100%);
            }

            .player-nick {
                color: #FFF;
                font-style: italic;
                text-align: right;
                text-transform: uppercase;
                margin-right: 0;
                padding-right: 25px;
                font-size: 1.5rem;
                bottom: 10px;
                position: absolute;
                width: 100%;
                z-index: 999;
            }

            .player-name {
                color: #000;
                font-style: italic;
                font-size: 1.4rem;
                margin-top: 10px;
                margin-left: 10px;
                text-align: left;
                font-weight: 600;
            }

            .player-img {
                position: absolute;
                height: 350px;
                background-size: cover;
                background-position: bottom center;
                width: 100%;
                margin-top: calc(270px - 350px);
                z-index: 999;
                clip-path: polygon(0 0, 100% 0%, 100% 80px, 100% 80px, 90% 100%, 0 100%, 10% 80px, 0% 80px);
            }

            .player-socials {
                margin-left: 10px;
                margin-top: 5px;
                margin-bottom: 30px;
            }

            .player-socials>a {
                color: #db0000;
                font-size: 1.6rem;
                margin-right: 12px;
            }

            .col {
                flex: 0 0 50%;
                margin-top: 0;
                max-width: 50%;
                padding: 5px;
            }

            .tech-col {
                display: flex;
                flex-wrap: wrap;
            }

            .tech-col .col {
                flex: 0 0 50%;
                max-width: 50%;
            }

            .tech-col .player-container {
                margin-top: 0;
                width: 100%;
                max-width: 100%;
            }

            .tech-col .single-player {
                background-color: #ececec;
                height: 200px;
                width: 100%;
                margin: 75px auto 0;
                clip-path: polygon(20% 0%, 100% 0%, 80% 100%, 0% 100%);
            }

            .tech-col .player-img {
                height: 270px;
                margin-top: calc(200px - 270px);
                clip-path: polygon(0 0, 100% 0%, 100% 70px, 100% 70px, 80% 100%, 0 100%, 20% 70px, 0% 70px);
            }

            .tech-col .player-nick {
                font-size: 1.5rem;
                bottom: 10px;
                margin-right: 0;
                padding-right: 25px;
                width: 100%;
                text-align: right;
            }

            .tech-col .player-name {
                font-size: 1.4rem;
                margin-top: 10px;
                margin-left: 10px;
                text-align: left;
                font-weight: 600;
            }

            .tech-col .player-socials {
                margin-left: 10px;
                margin-top: 5px;
                margin-bottom: 30px;
            }

            .tech-col .player-socials>a {
                font-size: 1.6rem;
                margin-right: 12px;
            }

            .page-heading {
                color: #FFF;
                font-size: 50px;
                font-style: italic;
                text-transform: uppercase;
                margin-top: 90px;
            }

            .teams-heading {
                height: 200px;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: center;
                padding-top: 30px !important;
                position: relative;
            }

            .teams-heading .col {
                width: 100%;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
            }

            .teams-heading .page-heading {
                margin-top: -20px;
                margin-bottom: 15px;
                text-align: center;
                position: relative;
                z-index: 10;
                width: 100%;
                white-space: nowrap;
                /* Ajuste a posição aqui: */
                margin-left: -45px;
            }

            .teams-heading .text-bg {
                font-size: 10vh;
                margin-top: -45px;
                margin-left: 0 !important;
                left: -114px;
                transform: none;
                position: relative;
                width: 100%;
                text-align: center;
            }

            .text-bg {
                font-size: 20vh;
                margin-top: -50px;
            }

            .teams-feature {
                margin-top: -270px;
            }

            .mt-5 {
                margin-top: 5rem !important;
            }

            .teams-feature .team-name {
                align-self: flex-end;
                text-align: right;
                width: 55%;
                font-size: 24px;
                font-weight: 500;
                font-style: italic;
                bottom: 12rem;
            }

            .single-player.tech {
                background-color: #ececec;
                height: 200px;
                width: 100%;
                margin: 75px auto;
                clip-path: polygon(20% 0%, 100% 0%, 80% 100%, 0% 100%);
            }

            .tech-col .player-img {
                height: 270px;
                margin-top: calc(200px - 270px);
                clip-path: polygon(0 0, 100% 0%, 100% 70px, 100% 70px, 80% 100%, 0 100%, 20% 70px, 0% 70px);
            }


            .row {
                margin-left: 0;
                margin-right: 0;
            }

            .players-col {
                margin-left: 0 !important;
                margin-right: 0 !important;
            }

            .col-1 {
                flex: 0 0 auto;
                width: 11.333333%;
            }

            .footer-copy {
                font-size: 1.7vh;
            }

            .container-fluid {
                padding-left: 15px;
                padding-right: 15px;
            }

            .main-header .banner-slider,
            .main-header .last-news,
            .main-header .banner-ad {
                padding-left: 15px !important;
                padding-right: 15px !important;
            }
        }

        @media (max-width: 435px) {
            html {
                overflow-x: hidden !important;
                max-width: 100vw;
            }

            body {
                overflow-x: hidden !important;
                max-width: 100vw;
                width: 100%;
            }

            * {
                max-width: 100%;
                box-sizing: border-box;
            }

            .team-feature-heading {
                height: 380px;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: center;
                padding-top: 30px !important;
            }

            .text-bg {
                font-size: 10vh;
                margin-top: -27px;
                margin-left: 0 !important;
                left: 50%;
                transform: translateX(-50%);
                width: 100%;
            }

            .teams-heading {
                height: 200px;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: center;
                padding-top: 30px !important;
                position: relative;
            }

            .teams-heading .col {
                width: 100%;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
            }

            .teams-heading .page-heading {
                margin-top: -20px;
                margin-bottom: 15px;
                text-align: center;
                position: relative;
                z-index: 10;
                width: 100%;
                white-space: nowrap;
                /* Ajuste a posição aqui: */
                margin-left: -45px;
            }

            .teams-heading .text-bg {
                font-size: 10vh;
                margin-top: -45px;
                margin-left: 0 !important;
                left: -114px;
                transform: none;
                position: relative;
                width: 100%;
                text-align: center;
            }

            .page-heading {
                color: #FFF;
                font-size: 40px;
                font-style: italic;
                text-transform: uppercase;
                margin-top: 80px;
            }

            .teams-feature {
                margin-top: -220px;
            }

            .text-bg-top {
                font-size: 11vh;
                margin-top: -235px;
                margin-left: 0 !important;
                left: 50%;
                transform: translateX(-50%);
                position: relative;
                width: 100%;
                text-align: center;
            }

            .team-name {
                text-align: center;
                width: 100%;
                display: flex;
                justify-content: center;
                align-items: center;
                position: relative;
                z-index: 10;
                margin-bottom: 100px;
            }

            .team-name>h2 {
                color: #FFF;
                font-size: 40px;
                font-style: italic;
                text-transform: uppercase;
                margin-top: 0;
                margin-bottom: 100px;
                text-align: center;
            }

            .awards-container {
                background-color: #171716;
                clip-path: polygon(10% 0, 100% 0, 90% 100%, 0% 100%);
                width: 95%;
                margin-left: 10px;
                margin-top: -10px;
            }

            .awards-container {
                background-color: #171716;
                clip-path: polygon(10% 0, 100% 0, 90% 100%, 0% 100%);
                width: 95%;
                max-width: 95%;
                margin-left: 10px;
                margin-top: -10px;
            }

            .team-card {
                height: 200px;
                width: 30%;
                margin: 5px;
                clip-path: polygon(23% 0%, 100% 0%, 77% 100%, 0% 100%);
            }

            .teams-feature {
                margin-top: -60px;
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                padding: 0 10px;
            }

            .teams-feature .col-lg-1 {
                display: none;
            }

            .teams-feature .team-name {
                font-size: 24px;
                bottom: 20px;
                width: 80%;
            }

            .awards-table div.tr {
                height: 60px;
                line-height: 60px;
                text-transform: uppercase;
                font-size: 1rem;
                width: 100%;
            }

            .teams-feature .team-name {
                align-self: flex-end;
                text-align: right;
                width: 46%;
                font-size: 18px;
                font-weight: 500;
                font-style: italic;
                bottom: 13rem;
            }

            .team-feature {
                margin-top: -220px;
                margin-right: 0 !important;
                margin-left: 0 !important;
                display: flex;
                flex-wrap: wrap;
                max-width: 100vw;
            }

            .row {
                margin-right: 0;
                margin-left: 0;
                max-width: 100%;
            }

            .players-col {
                max-width: 100%;
            }

            .col-9 {
                flex: 0 0 100%;
                width: 100%;
                max-width: 100%;
                padding: 0 15px;
                order: 1;
            }

            .col-3 {
                flex: 0 0 100%;
                width: 100%;
                max-width: 100%;
                padding: 0 15px;
                order: 2;
            }

            .col {
                flex: 0 0 50%;
                max-width: 50%;
                padding: 5px;
            }

            .player-container {
                position: relative;
                width: 100%;
                max-width: 100%;
                margin-left: 0;
                margin-bottom: 10px;
            }

            .single-player {
                background-color: #ececec;
                height: 270px;
                width: 100%;
                margin: 75px auto 0;
                clip-path: polygon(10% 0%, 100% 0%, 90% 100%, 0% 100%);
            }

            .player-img {
                position: absolute;
                height: 350px;
                background-size: cover;
                background-position: bottom center;
                width: 100%;
                margin-top: calc(270px - 350px);
                z-index: 999;
                clip-path: polygon(0 0, 100% 0%, 100% 80px, 100% 80px, 90% 100%, 0 100%, 10% 80px, 0% 80px);
            }

            .player-nick {
                color: #FFF;
                font-style: italic;
                text-align: right;
                text-transform: uppercase;
                margin-right: 0;
                padding-right: 20px;
                font-size: 1.3rem;
                bottom: 10px;
                position: absolute;
                width: 100%;
                z-index: 999;
            }

            .player-name {
                color: #000;
                font-style: italic;
                font-size: 1.3rem;
                margin-top: 10px;
                margin-left: 10px;
                text-align: left;
                font-weight: 600;
            }

            .player-socials {
                margin-left: 10px;
                margin-top: 5px;
                margin-bottom: 25px;
            }

            .player-socials>a {
                color: #db0000;
                font-size: 1.5rem;
                margin-right: 10px;
            }

            .tech-col {
                display: flex;
                flex-wrap: wrap;
            }

            .tech-col .col {
                flex: 0 0 50%;
                max-width: 50%;
            }

            .tech-col .single-player {
                background-color: #ececec;
                height: 200px;
                width: 100%;
                margin: 75px auto 0;
                clip-path: polygon(20% 0%, 100% 0%, 80% 100%, 0% 100%);
            }

            .tech-col .player-container {
                position: relative;
                width: 100%;
                max-width: 100%;
                margin: 0;
                margin-bottom: 10px;
            }

            .tech-col .player-nick {
                font-size: 1.3rem;
                bottom: 10px;
                margin-right: 0;
                padding-right: 40px;
                width: 100%;
                text-align: right;
            }

            .tech-col .player-img {
                height: 270px;
                margin-top: calc(200px - 270px);
                clip-path: polygon(0 0, 100% 0%, 100% 70px, 100% 70px, 80% 100%, 0 100%, 20% 70px, 0% 70px);
            }

            .tech-col .player-name {
                font-size: 1.3rem;
                margin-top: 10px;
                margin-left: 10px;
                text-align: left;
                font-weight: 600;
            }

            .tech-col .player-socials {
                margin-left: 10px;
                margin-top: 5px;
                margin-bottom: 25px;
            }

            .tech-col .player-socials>a {
                color: #db0000;
                font-size: 1.5rem;
                margin-right: 10px;
            }

            .sponsors {
                background-color: #db0000;
                width: 100%;
                height: 230px;
                line-height: 70px;
            }

            .sponsor-single {
                filter: invert(100%);
                height: 32px;
            }

            .col-4.f1 {
                flex: 0 0 auto;
                width: 33.33333333%;
                margin-right: 10px;
            }

            .col-5.c1 {
                margin-left: 77px;
            }

            .footer-copy {
                font-size: 2vh;
            }

            .col-4.f1 {
                flex: 0 0 auto;
                width: 33.33333333%;
                margin-right: 30px;
                margin-left: -20px;
            }
        }
    </style>

    <script type="text/javascript" src="../assets/libs/bootstrap/js/bootstrap.bundle.js"></script>
</body>

</html>